/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	DrawingSave.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFile.h"
#include "CApplication.h"

//  Save the drawing .
//  If the file is to be saved for the first time, then
//  SaveAs API has to be called instead of Save API.

HRESULT DrawingSave()
{

	START_METHOD("DrawingSave")

	HRESULT status = CONV_SUCCESS;
	IApplication *pdApplication = NULL;

	// get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IDispatch *pActiveDoc = NULL;
	status = pdApplication->GetActiveDoc(&pActiveDoc);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = CAST(IGraphicDocument, pActiveDoc);

	IDrawingDocument * activeDoc = CAST(IDrawingDocument, pActiveDoc);

	IDrawingDocOthers *doc = CAST(IDrawingDocOthers, activeDoc);

	// save the Drawing
	VARIANT_BOOL retval = FALSE;
	status = activeGraphicDoc->Save(&retval); 
	CHECK_RETURN_STATUS(status)

	END_METHOD("DrawingSave")
}
